﻿using System;
using System.Reflection;

/// <summary>
///     Dynamiczne aktywowanie kodu
/// </summary>
class DynamicActivation
{
    static void Main(string[] args)
    {
        DynamicActivation reflect = new DynamicActivation();

        Assembly myAssembly
            = Assembly.LoadFrom("Rozdzial 16.exe");

        reflect.DynamicallyInvokeMembers(myAssembly);

        Console.ReadKey();
    }

    void DynamicallyInvokeMembers(Assembly myAssembly)
    {
        Type classType = myAssembly.GetType("Reflected");

        PropertyInfo myProperty
            = classType.GetProperty("MyProperty");

        MethodInfo propGet = myProperty.GetGetMethod();

        object reflectedObject
            = Activator.CreateInstance(classType);

        propGet.Invoke(reflectedObject, null);

        MethodInfo myMethod
            = classType.GetMethod("MyInstanceMethod");

        myMethod.Invoke(reflectedObject, null);
    }
}
